/**
* \file: BdclLogging.cpp
*
* \version: $Id:$
*
* \release: $Name:$
*
* BDCL Logging context
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/
#include "BdclLogging.h"
#include <adit_logging.h>

/* @brief DLT context for all ADIT BDCL components.
 * */
#define DLT_CTXT_BDCL_TRANSPORT               "BTRA"
#define DLT_CTXT_BDCL_INIT                    "BINT"
#define DLT_CTXT_BDCL_CORE                    "BCRE"
#define DLT_CTXT_BDCL_AUDIO                   "BAUD"
#define DLT_CTXT_BDCL_GST                     "BVID"
#define DLT_CTXT_BDCL_INPUT                   "BINP"

/* @brief DLT context description for all ADIT BDCL components.
 * */
#define DLT_CTXT_DESC_BDCL_TRANSPORT           "BDCL Transport"
#define DLT_CTXT_DESC_BDCL_INIT                "BDCL Init"
#define DLT_CTXT_DESC_BDCL_CORE                "BDCL CORE"
#define DLT_CTXT_DESC_BDCL_AUDIO               "BDCL Ail Audio"
#define DLT_CTXT_DESC_BDCL_GST                 "BDCL Gstreamer video"
#define DLT_CTXT_DESC_BDCL_INPUT               "BDCL Unified input"

LOG_DECLARE_CONTEXT(bdcl_transport)
LOG_DECLARE_CONTEXT(bdcl_init)
LOG_DECLARE_CONTEXT(bdcl_core)
LOG_DECLARE_CONTEXT(bdcl_audio)
LOG_DECLARE_CONTEXT(bdcl_gst)
LOG_DECLARE_CONTEXT(bdcl_input)


void bdclRegisterCtxtWithDLT(void)
{
    /* register contexts */
    LOG_REGISTER_CONTEXT(bdcl_transport, DLT_CTXT_BDCL_TRANSPORT, DLT_CTXT_DESC_BDCL_TRANSPORT);
    LOG_REGISTER_CONTEXT(bdcl_init,      DLT_CTXT_BDCL_INIT,      DLT_CTXT_DESC_BDCL_INIT);
    LOG_REGISTER_CONTEXT(bdcl_core,      DLT_CTXT_BDCL_CORE,      DLT_CTXT_DESC_BDCL_CORE);


    LOG_REGISTER_CONTEXT(bdcl_audio,     DLT_CTXT_BDCL_AUDIO,     DLT_CTXT_DESC_BDCL_AUDIO);
    LOG_REGISTER_CONTEXT(bdcl_gst,       DLT_CTXT_BDCL_GST,       DLT_CTXT_DESC_BDCL_GST);
    LOG_REGISTER_CONTEXT(bdcl_input,     DLT_CTXT_BDCL_INPUT,     DLT_CTXT_DESC_BDCL_INPUT);

}

void bdclDeRegisterCtxtWithDLT(void)
{
    /* unregister contexts */
    LOG_UNREGISTER_CONTEXT(bdcl_transport);
    LOG_UNREGISTER_CONTEXT(bdcl_init);
    LOG_UNREGISTER_CONTEXT(bdcl_core);
    LOG_UNREGISTER_CONTEXT(bdcl_audio);
    LOG_UNREGISTER_CONTEXT(bdcl_gst);
    LOG_UNREGISTER_CONTEXT(bdcl_input);
}


